/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.FixedThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

final class QueueLimitedThreadPool
extends FixedThreadPool {
    private final Semaphore queuePermits;

    QueueLimitedThreadPool(ThreadPoolConfig config) {
        super(config);
        if (config.getQueueLimit() < 0) {
            throw new IllegalArgumentException("maxQueuedTasks < 0");
        }
        this.queuePermits = new Semaphore(config.getQueueLimit());
    }

    @Override
    public final void execute(Runnable command2) {
        if (command2 == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        if (!this.running) {
            throw new RejectedExecutionException("ThreadPool is not running");
        }
        if (!this.queuePermits.tryAcquire()) {
            this.onTaskQueueOverflow();
        }
        if (!this.workQueue.offer(command2)) {
            this.queuePermits.release();
            this.onTaskQueueOverflow();
        }
        this.onTaskQueued(command2);
    }

    @Override
    protected final void beforeExecute(AbstractThreadPool.Worker worker, Thread t, Runnable r) {
        super.beforeExecute(worker, t, r);
        this.queuePermits.release();
    }
}

